"""
HB_SymmetryMaker V1.2

Last Modified: Oct/11/2018
Works with CINEMA 4D R16-R20 and up.
Copyright: Holger Biebrach, www.c4dstuff.com

Name-US: HB_SymmetryMaker
Description-US: Deletes half of the Objects Points and Creates a Symmetry Object [SHIFT: Two Axis, SHIFT+CTRL: All Axis, ALT: negative Symmetry] 

Video Tutorial:
https://youtu.be/Ki6I9sRdeUU?t=39m5s
https://youtu.be/rAHc5mstOCg?t=622
https://youtu.be/UlY-X5O137M?t=808


ChangeLog:
Jun/11/2015 V1.0
-Release Version

Dez/2/2015 v1.1
- Bugfixes
- Removed Dialog


Oct/11/2018 v1.2
- Python Rewrite
- Multiple Objects Support
- Alt Modifier for Negative Symmetry
- Multiaxis Symmetry
- New Highres Icon¡




"""

import c4d
from c4d import utils


def ResetLocalCoordinates(obj):
    m = obj.GetMg()
    m.off = c4d.Vector(0,0,0)
    m.v1 = c4d.Vector(1,0,0)
    m.v2 = c4d.Vector(0,1,0)
    m.v3 = c4d.Vector(0,0,1)
    doc.AddUndo(c4d.UNDOTYPE_CHANGE, obj)
    obj.SetMl(m)


def deletehalfX(obj):

    sel = obj.GetAllPoints()
    pnts = c4d.BaseSelect()
    pnts.DeselectAll()
    points = [(i, point)
          for i, point in enumerate(obj.GetAllPoints())
          ]

    if not points:
      return
    sel = obj.GetPointS()
    sel.DeselectAll()


    if ALT:
    
        for i, point in points:
          pos=obj.GetPoint(i)
          xpos=pos.x
          if xpos > 0.001:
            sel.Select(i)

    else:
        for i, point in points:
            pos=obj.GetPoint(i)
            xpos=pos.x
            if xpos < -0.001:
                sel.Select(i)


    
    settings = c4d.BaseContainer()                 # Settings
    res = utils.SendModelingCommand(command = c4d.MCOMMAND_DELETE,
                                    list = [obj],
                                    mode = c4d.MODELINGCOMMANDMODE_POINTSELECTION,
                                    bc = settings,
                                    doc = doc)


def deletehalfY(obj):

    sel = obj.GetAllPoints()
    pnts = c4d.BaseSelect()
    pnts.DeselectAll()
    points = [(i, point)
          for i, point in enumerate(obj.GetAllPoints())
          ]

    if not points:
      return
    sel = obj.GetPointS()
    sel.DeselectAll()


    if ALT:
    
        for i, point in points:
          pos=obj.GetPoint(i)
          ypos=pos.y
          if ypos > 0.001:
            sel.Select(i)

    else:
        for i, point in points:
            pos=obj.GetPoint(i)
            ypos=pos.y
            if ypos < -0.001:
                sel.Select(i)


    
    settings = c4d.BaseContainer()                 # Settings
    res = utils.SendModelingCommand(command = c4d.MCOMMAND_DELETE,
                                    list = [obj],
                                    mode = c4d.MODELINGCOMMANDMODE_POINTSELECTION,
                                    bc = settings,
                                    doc = doc)
def deletehalfZ(obj):

    sel = obj.GetAllPoints()
    pnts = c4d.BaseSelect()
    pnts.DeselectAll()
    points = [(i, point)
          for i, point in enumerate(obj.GetAllPoints())
          ]

    if not points:
      return
    sel = obj.GetPointS()
    sel.DeselectAll()


    if ALT:
    
        for i, point in points:
          pos=obj.GetPoint(i)
          zpos=pos.z
          if zpos > 0.001:
            sel.Select(i)

    else:
        for i, point in points:
            pos=obj.GetPoint(i)
            zpos=pos.z
            if zpos < -0.001:
                sel.Select(i)


    
    settings = c4d.BaseContainer()                 # Settings
    res = utils.SendModelingCommand(command = c4d.MCOMMAND_DELETE,
                                    list = [obj],
                                    mode = c4d.MODELINGCOMMANDMODE_POINTSELECTION,
                                    bc = settings,
                                    doc = doc)

def MakeSymmetryX(obj):
    pos = obj.GetMg()
    name = obj.GetName()
    symObj=c4d.BaseObject(c4d.Osymmetry)
    
    symObj[c4d.SYMMETRYOBJECT_CLAMPPOINTS]=True
    symObj[c4d.SYMMETRYOBJECT_DELETEPOLYGONS]=True
    symObj.SetName(name +"_SymX")
    symObj.InsertAfter(obj)
    doc.AddUndo(c4d.UNDOTYPE_NEW, symObj)
    symObj.SetMg(pos)
    doc.AddUndo(c4d.UNDOTYPE_DELETE, obj)
    obj.Remove()
    
    obj.InsertUnder(symObj)
    doc.AddUndo(c4d.UNDOTYPE_NEW, obj)
    ResetLocalCoordinates(obj)
    if SHIFT or SHIFTCTRL: ResetLocalCoordinates(symObj)

def MakeSymmetryY(obj):
    pos = obj.GetMg()
    name = obj.GetName()
    symObj=c4d.BaseObject(c4d.Osymmetry)
   
    symObj[c4d.SYMMETRYOBJECT_CLAMPPOINTS]=True
    symObj[c4d.SYMMETRYOBJECT_DELETEPOLYGONS]=True
    symObj.SetName(name +"_SymY")
    symObj[c4d.SYMMETRYOBJECT_PLANE]=2
    symObj.InsertAfter(obj)
    doc.AddUndo(c4d.UNDOTYPE_NEW, symObj)
    symObj.SetMg(pos)
    doc.AddUndo(c4d.UNDOTYPE_DELETE, obj)
    obj.Remove()
    
    
    obj.InsertUnder(symObj)
    doc.AddUndo(c4d.UNDOTYPE_NEW, obj)
    ResetLocalCoordinates(obj)    

def MakeSymmetryZ(obj):
    pos = obj.GetMg()
    name = obj.GetName()
    symObj=c4d.BaseObject(c4d.Osymmetry)
    
    symObj[c4d.SYMMETRYOBJECT_CLAMPPOINTS]=True
    symObj[c4d.SYMMETRYOBJECT_DELETEPOLYGONS]=True
    symObj.SetName(name +"_SymZ")
    symObj[c4d.SYMMETRYOBJECT_PLANE]=0
    symObj.InsertAfter(obj)
    doc.AddUndo(c4d.UNDOTYPE_NEW, symObj)
    symObj.SetMg(pos)
    doc.AddUndo(c4d.UNDOTYPE_DELETE, obj)
    obj.Remove()
    
    
    obj.InsertUnder(symObj)
    doc.AddUndo(c4d.UNDOTYPE_NEW, obj)
    ResetLocalCoordinates(obj)
    if SHIFTCTRL:ResetLocalCoordinates(symObj)

def main():
    global ALT
    global SHIFT
    global CTRL
    global SHIFTCTRL
    activeobjects = doc.GetActiveObjects(c4d.GETACTIVEOBJECTFLAGS_CHILDREN) 
    
    
    bc = c4d.BaseContainer()
    c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD,c4d.BFM_INPUT_CHANNEL,bc)
              
    ALT=False
    SHIFT=False
    CTRL=False  
    SHIFTCTRL=False  
    
    if bc[c4d.BFM_INPUT_QUALIFIER] ==1 : SHIFT=True
    if bc[c4d.BFM_INPUT_QUALIFIER] ==2 : CTRL=True
    if bc[c4d.BFM_INPUT_QUALIFIER] ==3 : SHIFTCTRL=True
    if bc[c4d.BFM_INPUT_QUALIFIER] ==4 : ALT=True
    

    
    
    
    
    for obj in activeobjects:
        doc.AddUndo(c4d.UNDOTYPE_CHANGE, obj)
        #objpos=obj.GetMg()
        deletehalfX(obj)
        
        if SHIFT: 
            deletehalfZ(obj)
            MakeSymmetryZ(obj)
        if SHIFTCTRL:
            deletehalfY(obj)
            MakeSymmetryY(obj)
            deletehalfZ(obj)
            MakeSymmetryZ(obj)
          
        MakeSymmetryX(obj)
        #obj.SetMg(objpos)
    c4d.EventAdd()

    
    
     

if __name__=='__main__':
    main()
